// SPDX-License-Identifier: Zlib
//
// Copyright (C) 2025 Antonio Niño Díaz

#ifndef BLOCKSDS_VERSION_H__
#define BLOCKSDS_VERSION_H__

/// Major part of the version
#define BLOCKSDS_VERSION_MAJOR 1
/// Minor part of the version
#define BLOCKSDS_VERSION_MINOR 15
/// Patch part of the version
#define BLOCKSDS_VERSION_PATCH 7

// Macro to compose an integer that represents a version number
#define BLOCKSDS_VERSION_MAKE(major, minor, patch) \
    ((major << 16) | (minor << 8) | (patch << 0))

/// Integer that represents the version number of this build
#define BLOCKSDS_VERSION_FULL \
    BLOCKSDS_VERSION_MAKE(BLOCKSDS_VERSION_MAJOR, BLOCKSDS_VERSION_MINOR, BLOCKSDS_VERSION_PATCH)

/// Full version string
#define BLOCKSDS_VERSION_STRING "v1.15.7-dirty"

/// This is 1 if the current build of BlocksDS is a tagged (official) release
#define BLOCKSDS_VERSION_IS_TAGGED 0

// Returns true if the version of BlocksDS is the specified one
#define BLOCKSDS_VERSION_EQUALS(major, minor, patch) \
    (BLOCKSDS_VERSION_FULL == BLOCKSDS_VERSION_MAKE(major, minor, patch))

// Returns true if the version of BlocksDS is at least the specified one
#define BLOCKSDS_VERSION_AT_LEAST(major, minor, patch) \
    (BLOCKSDS_VERSION_FULL >= BLOCKSDS_VERSION_MAKE(major, minor, patch))

// Returns true if the version of BlocksDS is at most the specified one
#define BLOCKSDS_VERSION_AT_MOST(major, minor, patch) \
    (BLOCKSDS_VERSION_FULL <= BLOCKSDS_VERSION_MAKE(major, minor, patch))

#endif // BLOCKSDS_VERSION_H___
