# BlocksDS SDK examples

This folder contains several examples of how to use the features of the
libraries included in BlocksDS. The folders contain examples that relate to one
specific area:

- `audio`: How to use the audio functions of libnds (without external libraries).
- `bios`: How to use the services provided by the BIOS.
- `compression`: Decompressing data included in your application.
- `cmake`: How to use CMake to build projects using BlocksDS.
- `console`: How to use features of the text console of libnds.
- `cothread`: How to use the co-operative multithreading library of libnds.
- `debug`: How to enable and use some debug features of libnds.
- `demos`: Simple "completed" games, designed to be used as reference.
- `dsp`: Examples of how to use the DSP of the DSi.
- `dswifi`: DSWiFi library features.
- `dynamic_libs`: How to load dynamic libraries with libnds.
- `filesystem`: How to access the 3 filesystems of the DS/DSi.
- `firmware`: User firmware settings.
- `gl2d`: How to use the GL2D library for 2D graphics with the 3D hardware.
- `graphics_2d`: 2D graphics features of the DS.
- `graphics_3d`: 3D graphics features of the DS (alone or alongside 2D graphics).
- `input`: How to get input data from the user (keyboard, keys, touch screen).
- `interrupts`: How to use hardware interrupts.
- `ipc`: Transfer of information between the ARM9 and the ARM7.
- `keyboard`: How to use the keyboard API of libnds.
- `libxm7`: How to use the features of LibXM7.
- `maxmod`: How to use the features of Maxmod.
- `peripherals`: Using integrated, Slot-1 and Slot-2 peripherals.
- `time`: How to use timers and the RTC.
- `version`: Check that the installed version of BlocksDS is supported by a project.
- `video_capture`: Capturing the main engine graphics output and using it later.
- `video_effects`: How to use 2D effects like blending and windows.
