---
title: 'BlocksDS Documentation'
---

Welcome to the documentation of BlocksDS, an SDK for the Nintendo DS.

This is an [introduction](./introduction/introduction) to the SDK.

If you're looking for information on how to install BlocksDS, check the
[instructions](./setup/options).

If you're looking for support, check [this page](./introduction/support).

If you're looking for documentation about specific libraries of BlocksDS,
check the following links:

- **libnds**: General-purpose library to use the hardware of the NDS.

  - [Library documentation](./libnds/index.html)
  - [Examples](https://github.com/blocksds/sdk/tree/master/examples)

- **Maxmod**: Music player that can play MOD, S3M, XM, IT and WAV files. It can
  use hardware or software mixing, and it runs on the ARM7.

  - [Library documentation](./maxmod/index.html)
  - [Examples](https://github.com/blocksds/sdk/tree/master/examples/maxmod)

- **LibXM7**: Hardware-accelerated player of XM and MOD music files that runs
  on the ARM7.

  - [Library documentation](./libxm7/index.html)
  - [Examples](https://github.com/blocksds/sdk/tree/master/examples/libxm7)

- **DSWiFi**: Library to use the WiFi hardware of the NDS and DSi with support
  for local multiplayer and Internet access.

  - [Library documentation](./dswifi/index.html)
  - [Examples](https://github.com/blocksds/sdk/tree/master/examples/dswifi)

- **libteak**: Library to use the Teak DSP included in the DSi and 3DS consoles.

  - [Library documentation](./libteak/index.html)
  - [Examples](https://github.com/blocksds/sdk/tree/master/examples/dsp)

There are also some libraries and tools that are supported by BlocksDS, but not
fully integrated with it. They include libraries to easily handle 2D and 3D
graphics, additional converters for graphics and build systems. Take a look at
the [documentation](./setup/additional_libs) for more information.
