// SPDX-License-Identifier: CC0-1.0
//
// SPDX-FileContributor: Antonio Niño Díaz, 2024

#include <nds.h>

// This is autogenerated from forest_town.png and forest_town.grit
#include "forest_town.h"

int main(int argc, char *argv[])
{
    videoSetMode(MODE_0_2D);

    vramSetPrimaryBanks(VRAM_A_MAIN_BG, VRAM_B_LCD, VRAM_C_LCD, VRAM_D_LCD);

    int bg = bgInit(0, BgType_Text8bpp, BgSize_T_256x256, 0,1);

    dmaCopy(forest_townTiles, bgGetGfxPtr(bg), forest_townTilesLen);
    dmaCopy(forest_townMap, bgGetMapPtr(bg), forest_townMapLen);
    dmaCopy(forest_townPal, BG_PALETTE, forest_townPalLen);

    // Make the backgdrop color black. This is the color that gets drawn on the
    // screen if no background or sprite is in that part of the screen. This
    // value is stored in BG_PALETTE[0], so it must be set after copying the
    // background palette.
    setBackdropColor(RGB15(0, 0, 0));

    // Setup two windows. Window 0 has priority over window 1. In this example,
    // windows 0 is a small rectangle in the center of the screen, and window 1
    // is a rectangle that covers most of the screen:
    //
    // - The outside of the big rectangle isn't inside window 1, so the
    //   background isn't visible.
    //
    // - The inside of window 1 has enabled the display of the background, so it
    //   is visible.
    //
    // - Windows 0 has disabled the background, and it takes priority over
    //   window 1, so it isn't visible inside.
    windowSetBounds(WINDOW_0, 48, 48, SCREEN_WIDTH - 48, SCREEN_HEIGHT - 48);
    windowSetBounds(WINDOW_1, 16, 16, SCREEN_WIDTH - 16, SCREEN_HEIGHT - 16);
    bgWindowDisable(bg, WINDOW_0);
    bgWindowEnable(bg, WINDOW_1);
    bgWindowDisable(bg, WINDOW_OUT);
    windowEnable(WINDOW_0 | WINDOW_1);

    consoleDemoInit();

    printf("PAD:   Scroll background\n");
    printf("START: Exit to loader\n");

    int x = 150, y = 70;

    while (1)
    {
        swiWaitForVBlank();

        bgSetScroll(bg, x, y);

        bgUpdate();

        scanKeys();

        u16 keys_held = keysHeld();

        if (keys_held & KEY_UP)
            y--;
        else if (keys_held & KEY_DOWN)
            y++;

        if (keys_held & KEY_LEFT)
            x--;
        else if (keys_held & KEY_RIGHT)
            x++;

        if (keys_held & KEY_START)
            break;
    }

    return 0;
}
