// SPDX-License-Identifier: CC0-1.0
//
// SPDX-FileContributor: Antonio Niño Díaz, 2024-2025

// This example shows how to change the brightness of the screen. The registers
// affect all the graphics output (2D and 3D), and it's different from changing
// the LCD brightness setting (this is purely a software fade factor).

#include <stdio.h>

#include <nds.h>

// Headers autogenerated for each PNG file inside GFXDIRS in the Makefile
#include "forest_town.h"

int main(int argc, char **argv)
{
    videoSetMode(MODE_0_2D);

    // Setup some VRAM as memory for main engine background
    vramSetBankA(VRAM_A_MAIN_BG);

    // Setup background
    int bg = bgInit(2, BgType_Text8bpp, BgSize_T_256x256, 0, 4);
    bgSetPriority(bg, 2);

    // Copy background graphics
    dmaCopy(forest_townTiles, bgGetGfxPtr(bg), forest_townTilesLen);
    dmaCopy(forest_townMap, bgGetMapPtr(bg), forest_townMapLen);
    dmaCopy(forest_townPal, BG_PALETTE, forest_townPalLen);

    // Setup console in the sub screen
    consoleDemoInit();

    int brightness = 0;

    while (1)
    {
        // Synchronize game loop to the screen refresh
        swiWaitForVBlank();

        // Print some text in the demo console
        // -----------------------------------

        consoleClear();

        // Print some controls
        printf("Brightness: %d\n", brightness);
        printf("\n");
        printf("\n");
        printf("UP/DOWN: Set value (-16 to 16)\n");
        printf("START:   Exit to loader\n");
        printf("\n");

        // Set brightness for both screens
        // -------------------------------

        setBrightness(3, brightness);

        // Handle user input
        // -----------------

        scanKeys();

        uint16_t keys = keysDown();

        if ((keys & KEY_UP) && (brightness < 16))
            brightness ++;
        if ((keys & KEY_DOWN) && (brightness > -16))
            brightness --;

        if (keys & KEY_START)
            break;
    }

    return 0;
}
