# BlocksDS SDK examples: 3D graphics

This folder contains examples of how to use the 3D features of the DS with
libnds.

- `2d_and_3d`: Combines 2D sprites and background with the 3D output.
- `antialiasing_and_edge_marking`: How to use antialiasing and edge marking.
- `alpha_test`: It shows the effect of the alpha test setting.
- `basic_cube`: It draws a simple 3D cube and shows the effects of culling.
- `basic_texture`: Loads a 16 bpp texture from the ARM9 binary.
- `billboards`: Display 2D objects that always face the camera in a 3D world.
- `box_test`: Uses the box test to detect if a cube is displayed on the screen.
- `colored_polygon`: Very simple example of how to draw a colored polygon.
- `compressed_texture`: Loads a compressed/Tex4x4 texture from the ARM9 binary.
- `depth_buffering_modes`: Shows the difference between Z and W-buffering.
- `display_list_creation`: Manually creates a display list and uses it.
- `display_list_teapot`: Displays a pre-converted teapot model.
- `display_list_nitrofs`: Loads a pre-converted teapot model from NitroFS.
- `fog`: How to use hardware fog to fade 3D objects in a 3D environment.
- `fog_over_2d`: How to use hardware fog to fade 3D objects on top of 2D layers.
- `grf_textures_nitrofs`: How to load textures stored as GRF files in NitroFS.
- `lighting_cube`: It shows how to display a cube with lighting.
- `lighting_materials`: It shows the effect of different materials.
- `ortho_projection`: It uses an orthogonal projection instead of perspective.
- `paletted_textures`: It loads paletted textures from the ARM9 binary.
- `picking`: How to detecti if a 3D object is being pressed in the touch screen.
- `point_light`: How to implement fake spot lights using directional lights.
- `modulation_vs_decal`: Show difference between modulation and decal poly modes.
- `sort_translucent_objects`: How to sort and draw translucent objects.
- `text_over_3d`: How to display the libnds console over the 3D output.
- `texture_edge_modes`: Shows the behaviour of all modes of texture overflows.
- `texture_matrix`: How to use the texture matrix to achieve special effects.
- `toon_shading`: How to achieve a toon shading effect.
- `translucent_cube`: How to draw a cube with translucent faces correctly.
- `translucent_polygon`: How to draw translucent polygons (alpha per polygon).
- `translucent_texture`: How to use translucent textures (alpha per pixel).
- `volumetric_shadow`: How to display hardware accelerated volumetric shadows.
