// SPDX-License-Identifier: CC0-1.0
//
// SPDX-FileContributor: Antonio Niño Díaz, 2025

#include <nds.h>

#include "map.h"

// This is autogenerated from forest_town.png and forest_town.grit
#include "forest_town.h"

#define FOREST_TOWN_WIDTH   1024
#define FOREST_TOWN_HEIGHT  768

int main(int argc, char *argv[])
{
    consoleDemoInit();

    videoSetMode(MODE_0_2D);

    vramSetBankA(VRAM_A_MAIN_BG);

    printf("PAD:    Scroll background\n");
    printf("SELECT: Jump to random position\n");
    printf("\n");
    printf("START:  Exit to loader\n");

    map_load(0,    // Background layer
             0, 1, // Map base, tile base
             forest_townMap,                        // Map data
             FOREST_TOWN_WIDTH, FOREST_TOWN_HEIGHT, // Map dimensions in pixels
             forest_townTiles, forest_townTilesLen, // Tile data and size
             forest_townPal, forest_townPalLen);    // Palette data and size

    // Start at an arbitrary position to show that it's a possibility
    map_set_position(30, 15);

    while (1)
    {
        swiWaitForVBlank();

        map_refresh_scroll();

        bgUpdate();

        scanKeys();

        u16 keys_held = keysHeld();
        u16 keys_down = keysDown();

        // Do player scroll
        if (keys_held & KEY_UP)
            map_scroll_y(-3);
        else if (keys_held & KEY_DOWN)
            map_scroll_y(3);

        if (keys_held & KEY_LEFT)
            map_scroll_x(-3);
        else if (keys_held & KEY_RIGHT)
            map_scroll_x(3);

        if (keys_down & KEY_SELECT)
        {
            int x = rand() % map_get_max_scroll_x();
            int y = rand() % map_get_max_scroll_y();
            map_set_position(x, y);
        }

        if (keys_held & KEY_START)
            break;
    }

    return 0;
}
