// SPDX-License-Identifier: CC0-1.0
//
// SPDX-FileContributor: Antonio Niño Díaz, 2025

// This example shows how to display a 16-bit bitmap that is bigger than what
// you can store in VRAM.

#include <nds.h>

#include "map.h"

// This is autogenerated from forest_town.png and forest_town.grit
#include "forest_town.h"

#define FOREST_TOWN_WIDTH   1024
#define FOREST_TOWN_HEIGHT  768

int main(int argc, char *argv[])
{
    consoleDemoInit();

    // Use mode 5 so that we can use layer 2 as a bitmap
    videoSetMode(MODE_5_2D);

    vramSetBankA(VRAM_A_MAIN_BG_0x06000000);
    vramSetBankB(VRAM_B_MAIN_BG_0x06020000);

    printf("PAD:    Scroll background\n");
    printf("SELECT: Jump to random position\n");
    printf("\n");
    printf("START:  Exit to loader\n");

    map_load(2,    // Background layer
             0,    // Map base
             forest_townBitmap,                      // Map data
             FOREST_TOWN_WIDTH, FOREST_TOWN_HEIGHT); // Map dimensions in pixels

    // Start at an arbitrary position to show that it's a possibility
    map_set_position(30, 15);

    while (1)
    {
        swiWaitForVBlank();

        map_refresh_scroll();

        bgUpdate();

        scanKeys();

        u16 keys_held = keysHeld();
        u16 keys_down = keysDown();

        // Do player scroll
        if (keys_held & KEY_UP)
            map_scroll_y(-3);
        else if (keys_held & KEY_DOWN)
            map_scroll_y(3);

        if (keys_held & KEY_LEFT)
            map_scroll_x(-3);
        else if (keys_held & KEY_RIGHT)
            map_scroll_x(3);

        if (keys_down & KEY_SELECT)
        {
            int x = rand() % map_get_max_scroll_x();
            int y = rand() % map_get_max_scroll_y();
            map_set_position(x, y);
        }

        if (keys_held & KEY_START)
            break;
    }

    return 0;
}
