---
title: 'Base libraries'
weight: 1
---

All the base libraries included with BlocksDS come with extensive documentation
and examples. If you want information about other libraries not included with
the base SDK, check the links [here](..).

### libnds

General-purpose library to use the hardware of the NDS.

{{< cards cols="2" >}}
  {{< card
    icon="book-open"
    title="Documentation"
    link="../../../libnds/index.html"
  >}}
  {{< card
    icon="code"
    title="Examples"
    link="https://codeberg.org/blocksds/sdk/src/branch/master/examples"
  >}}
{{< /cards >}}

### Maxmod

Music player that can play MOD, S3M, XM, IT and WAV files. It can use hardware
or software mixing, and it runs on the ARM7.

{{< cards cols="2" >}}
  {{< card
    icon="book-open"
    title="Documentation"
    link="../../../maxmod/index.html"
  >}}
  {{< card
    icon="code"
    title="Examples"
    link="https://codeberg.org/blocksds/sdk/src/branch/master/examples/maxmod"
  >}}
{{< /cards >}}

### DSWiFi

Library to use the WiFi hardware of the NDS and DSi with support for local
multiplayer and Internet access.

{{< cards cols="2" >}}
  {{< card
    icon="book-open"
    title="Documentation"
    link="../../../dswifi/index.html"
  >}}
  {{< card
    icon="code"
    title="Examples"
    link="https://codeberg.org/blocksds/sdk/src/branch/master/examples/dswifi"
  >}}
{{< /cards >}}

### LibXM7

Hardware-accelerated player of XM and MOD music files that runs on the ARM7.

{{< cards cols="2" >}}
  {{< card
    icon="book-open"
    title="Documentation"
    link="../../../libxm7/index.html"
  >}}
  {{< card
    icon="code"
    title="Examples"
    link="https://codeberg.org/blocksds/sdk/src/branch/master/examples/libxm7"
  >}}
{{< /cards >}}

### libteak

Library to use the Teak DSP included in the DSi and 3DS consoles.

{{< cards cols="2" >}}
  {{< card
    icon="book-open"
    title="Documentation"
    link="../../../libteak/index.html"
  >}}
  {{< card
    icon="code"
    title="Examples"
    link="https://codeberg.org/blocksds/sdk/src/branch/master/examples/dsp"
  >}}
{{< /cards >}}

### Grit

Graphics converter for GBA and NDS.

{{< cards cols="2" >}}
  {{< card
    icon="book-open"
    title="Documentation"
    link="../../../grit/index.html"
  >}}
  {{< card
    icon="code"
    title="Repository"
    link="https://codeberg.org/blocksds/grit"
  >}}
{{< /cards >}}
