---
title: 'User guides'
weight: 4
---

This section has documentation that users of BlocksDS may find useful while
developing applications.

- [C/C++ support](libc): Information about what functionality from standard C
  and C++ libraries is supported in BlocksDS.

- [Debugging guide](debugging): It explains different ways to debug programs.

- [DLDI in ARM7](dldi_arm7): It explains the benefits of running DLDI in the
  ARM7 (as opposed of using it in the ARM9) and how to switch CPUs.

- [Filesystem support](filesystem): It explains how to initialize and use the
  multiple filesystems available (SD cards, embedded filesystem in NDS ROMs,
  NAND).

- [Frequently asked questions](faq): Answers to some frequently asked questions.

- [Legacy device/launcher support](legacy_support): Information about how to get
  applications running in old Slot-2 flashcards when in DS mode.

- [Licenses](licenses): Short guide about the licenses used by libraries in
  BlocksDS and what they mean to applications using them.

- [Migrating from devkitARM](devkitarm_porting_guide): Steps to port
  applications created for devkitARM (particularly the ones created before
  November 2024 with their Calico update).

- [Optimization guide](optimization_guide): Some tips on how to optimize your
  applications.

- [Upgrade guide](updating_guide): Description of changes between versions of
  BlocksDS that may affect pre-existing programs.

- [Usage notes](usage_notes): Some notes about how to use lesser-known features
  of BlocksDS.
